package gov.va.vinci.dart.db.mock;

import gov.va.vinci.dart.biz.Event;
import gov.va.vinci.dart.biz.EventSummary;
import gov.va.vinci.dart.db.EventDAO;
import gov.va.vinci.dart.service.DartObjectFactory;

import java.util.ArrayList;
import java.util.List;

public class ActivityEventSummaryDAOMock {

	private int activityId;
	
	public ActivityEventSummaryDAOMock(int activityId) {
		this.activityId = activityId;
	}
	
	public List<EventSummary> build() {
		List<EventSummary> result = new ArrayList<EventSummary>();
		
		EventDAO mock = DartObjectFactory.getInstance().getEventDAO();
		
		for (Event event : mock.listByActivityId(activityId)) {
			EventSummary es = new EventSummary();
			es.setActivityId(event.getRequest().getActivity().getId());
			es.setRequestId(event.getRequest().getId());
			es.setDescription(event.getDescription());
			result.add(es);
		}

		return result;
		
	}
}
